/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool.collection;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class StreamSplitter<T> {
    private final Stream<T> stream;
    private final Set<Splitter> splitters = new HashSet<Splitter>();

    public StreamSplitter(Stream<T> stream) {
        this.stream = stream;
    }

    public StreamSplitter<T> dispatch(Predicate<T> acceptanceFilter, Consumer<T> consumer) {
        this.splitters.add(new Splitter(acceptanceFilter, consumer));
        return this;
    }

    public void split() {
        this.stream.forEach(t -> this.splitters.forEach(splitter -> {
            if (((Splitter)splitter).splitter.test(t)) {
                ((Splitter)splitter).consumer.accept(t);
            }
        }));
    }

    private class Splitter {
        private final Predicate<T> splitter;
        private final Consumer<T> consumer;

        private Splitter(Predicate<T> splitter, Consumer<T> consumer) {
            this.splitter = splitter;
            this.consumer = consumer;
        }
    }
}

